#include "AD18F08_Com.h"


volatile unsigned char	USART_BUF @0x20;
volatile bit D0			@ ((unsigned)&USART_BUF*8)+0;
volatile bit D1			@ ((unsigned)&USART_BUF*8)+1;
volatile bit D2			@ ((unsigned)&USART_BUF*8)+2;
volatile bit D3			@ ((unsigned)&USART_BUF*8)+3;
volatile bit D4			@ ((unsigned)&USART_BUF*8)+4;
volatile bit D5			@ ((unsigned)&USART_BUF*8)+5;
volatile bit D6			@ ((unsigned)&USART_BUF*8)+6;
volatile bit D7			@ ((unsigned)&USART_BUF*8)+7;



void usart_init(void)
{
	TX_DIR=0; 
	TX_PIN=1;

	RX_DIR=1;
}

void putch(unsigned char tmp)
{
	USART_BUF = tmp;
	unsigned char i=0;
	TX_PIN = 1;
	TX_PIN = 0;
	__delay_us(104);	
	for(i=0;i<8;i++)
	{
		TX_PIN=tmp&0X01;
		__delay_us(100);
		tmp=tmp>>1;
	}
	TX_PIN = 1;
	__delay_us(104);
	__delay_us(104);
}

unsigned char getch(void)
{
	unsigned char  tmp      = 0;
    unsigned char  Time_out = 250;

    while(RX_PIN ==1 )
	{
       Time_out--;
	   if(Time_out == 0)return 0;
	}

	__delay_us(104);
	__delay_us(52);
	if (RX_PIN==1)
		tmp = tmp | 0x01;	
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x02;			
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x04;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x08;	
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x10;			
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x20;			
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x40;			
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x80;			
	__delay_us(104);
	
	if (RX_PIN==1)
		return tmp;
	else
		return 0;
}

